package com.qboxus.tictic.viewModels

import android.content.Context
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.viewModelScope
import com.qboxus.tictic.activitesfragments.location.DeliveryAddress
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.models.HomeModel
import com.qboxus.tictic.models.SettingsModel
import com.qboxus.tictic.repositories.AddressRepository
import com.qboxus.tictic.repositories.SplashRepository
import com.qboxus.tictic.repositories.VideosRepository
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Variables
import kotlinx.coroutines.launch
import org.json.JSONObject

class SplashViewModel(
    private val context: Context,
    private val settingRepository: SplashRepository,
    private val addressRepository: AddressRepository,
    private val videoRepository: VideosRepository
): ViewModel() {

    val _settingsLiveData: MutableLiveData<ApiResponce<ArrayList<SettingsModel>>> = MutableLiveData()
    val settingsLiveData: LiveData<ApiResponce<ArrayList<SettingsModel>>> get() = _settingsLiveData

    val _deliveryAddressLiveData: MutableLiveData<ApiResponce<ArrayList<DeliveryAddress>>> = MutableLiveData()
    val deliveryAddressLiveData: LiveData<ApiResponce<ArrayList<DeliveryAddress>>> get() = _deliveryAddressLiveData


    val _adLiveData: MutableLiveData<ApiResponce<HomeModel>> = MutableLiveData()
    val adLiveData: LiveData<ApiResponce<HomeModel>> get() = _adLiveData


    fun showSettings(){
        viewModelScope.launch {
            val params = JSONObject()
            settingRepository.showSettings(params,_settingsLiveData)
        }

    }

    fun getAddressList(){
        viewModelScope.launch {
            val param = JSONObject()
            param.put("user_id",
                Functions.getSharedPreference(context)
                    .getString(Variables.U_ID, "")
            )

            addressRepository.showDeliveryAddresses(param, _deliveryAddressLiveData)
        }
    }

    fun getAdsVideo(){
        viewModelScope.launch {
            val param = JSONObject()
            if(Functions.getSharedPreference(context).getBoolean(Variables.IS_LOGIN,false)) {
                param.put(
                    "user_id",
                    Functions.getSharedPreference(context)
                        .getString(Variables.U_ID, "")
                )
            }

            videoRepository.showVideoDetailAd(param, _adLiveData)
        }
    }

}

